import math

n, eps = input().split()
n = int(n)
eps = float(eps)

points = [tuple(map(float, input().split())) for _ in range(n)]

def manhattan(p1, p2):
    return abs(p1[0]-p2[0]) + abs(p1[1]-p2[1])

used = [False]*n
dist = [math.inf]*n
parent = [-1]*n
dist[0] = 0
mst_edges = []

for _ in range(n):
    u = -1
    
    for i in range(n):
        
        if not used[i] and (u==-1 or dist[i]<dist[u]):
            u = i
            
    used[u] = True
    
    if parent[u] != -1:
        mst_edges.append((parent[u], u))
        
    for v in range(n):
        
        if not used[v]:
            
            d = manhattan(points[u], points[v])
            
            if d < dist[v]:
                dist[v] = d
                parent[v] = u

adj = [[] for _ in range(n)]

for u,v in mst_edges:
    adj[u].append(v)
    adj[v].append(u)

Q = set()
covered = [False]*n

def dfs(u, par):

    for v in Q:
        
        if manhattan(points[u], points[v]) <= eps:
            covered[u] = True
            break
            
    if not covered[u]:
        Q.add(u)
        covered[u] = True
        
    for v in adj[u]:
        
        if v != par:
            dfs(v, u)

dfs(0, -1)

Q = sorted(list(Q))
k = len(Q)

used = [False]*k
dist = [math.inf]*k
parent = [-1]*k
dist[0] = 0
edges_T = []

for _ in range(k):
    u = -1
    
    for i in range(k):
        
        if not used[i] and (u==-1 or dist[i]<dist[u]):
            u = i
            
    used[u] = True
    
    if parent[u] != -1:
        edges_T.append((Q[parent[u]]+1, Q[u]+1))
        
    for v in range(k):
        
        if not used[v]:
            d = manhattan(points[Q[u]], points[Q[v]])
            
            if d < dist[v]:
                dist[v] = d
                parent[v] = u


print(k)
print(' '.join(str(x+1) for x in Q))

for u,v in edges_T:
    print(u,v)